IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_SAI_DAR]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_NF_SAI_DAR](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[CD_DAR] [int] NOT NULL,
	[VLR_DAR] [money] NOT NULL,
	[DT_CAD] [datetime] NULL,
	[CD_USU] [int] NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[VLR_DAR_DIF] [money] NOT NULL,
	[VLR_DAR_RECOLHER] [money] NOT NULL,
	[XML_PROCESSAMENTO] [xml] NULL,
	[VLR_ICMS_RETIDO] [money] NULL,
	[DAR_PAGO_PELO_FORNECEDOR] [int] NOT NULL,
	[VLR_DAR_PAGO_PELO_FORNECEDOR] [money] NOT NULL,
	[NR_DAR] [varchar](150) NULL,
	[CD_AUTENTICACAO] [varchar](150) NULL,
	[DT_VENCTO] [datetime] NULL,
	[DT_RECOLHIMENTO] [datetime] NULL,
 CONSTRAINT [PK_EST_NF_SAI_DAR] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_DAR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]


ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_CD_DAR]  DEFAULT ((0)) FOR [CD_DAR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_VLR_DAR]  DEFAULT ((0)) FOR [VLR_DAR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_VLR_DAR_DIF]  DEFAULT ((0)) FOR [VLR_DAR_DIF]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_VLR_DAR_RECOLHER]  DEFAULT ((0)) FOR [VLR_DAR_RECOLHER]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_VLR_ICMS_RETIDO]  DEFAULT ((0)) FOR [VLR_ICMS_RETIDO]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_DAR_PAGO_PELO_FORNECEDOR]  DEFAULT ((0)) FOR [DAR_PAGO_PELO_FORNECEDOR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_VLR_DAR_PAGO_PELO_FORNECEDOR]  DEFAULT ((0)) FOR [VLR_DAR_PAGO_PELO_FORNECEDOR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_NR_DAR]  DEFAULT ('') FOR [NR_DAR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_CD_AUTENTICACAO]  DEFAULT ('') FOR [CD_AUTENTICACAO]

ALTER TABLE [dbo].[EST_NF_SAI_DAR]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_DAR_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_SAI_DAR] CHECK CONSTRAINT [FK_EST_NF_SAI_DAR_EST_NF_SAI]
end
